package com.zjx.cloud.alibaba.sentinel.config;

import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.RequestOriginParser;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

/**
 * 设置授权规则--为当前服务设置应用名
 * 在 Sentinel 控制台中新增授权规则时，可以为指定的应用名分配可访问的资源
 */
@Component
public class MyRequestOriginParser implements RequestOriginParser {
    @Override
    public String parseOrigin(HttpServletRequest request) {
        return "app-shop";
    }
}
