package com.zjx.cloud.alibaba.sentinel;


import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@EnableDiscoveryClient
public class CloudAlibabaSentinelApplication {
	public static void main(String[] args) {
		SpringApplication.run(CloudAlibabaSentinelApplication.class, args);
	}
	@RestController
    public static class TestController {
		@GetMapping(value = "/hello/{name}")
		@SentinelResource(value = "hello",blockHandler = "myHandler",fallback = "myFallback")
		public String hello(@PathVariable("name") String name) {
			if("zs".equals(name)) throw new RuntimeException("走开！");
			return "Hello Sentinel: " + name;
		}
		public String myHandler(String name, BlockException ex) {
			return "限流（服务熔断）提示：失败了！" + ex.getMessage() + "方法参数：" + name;
		}
		public String myFallback(String name, Throwable throwable) {
			return "异常（服务降级）提示：失败了！" + throwable.getMessage() + "方法参数：" + name;
		}

		@GetMapping(value = "/test/{productId}/{userId}")
		@SentinelResource(value = "order")
		public String order(@PathVariable("productId") String productId, @PathVariable("userId") String userId) {
			return "Hello productId: " + productId + ", userId: " + userId;
		}
	}
}

