package com.zjx.cloud.alibaba.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zjx.cloud.alibaba.entity.Storage;
import com.zjx.cloud.alibaba.mapper.StorageMapper;
import com.zjx.cloud.alibaba.service.IStorageService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author zjx
 * @since 2024-08-02
 */
@Service
@DS("db2")
public class StorageServiceImpl extends ServiceImpl<StorageMapper, Storage> implements IStorageService {

    private StorageMapper storageMapper;

    @Autowired
    public StorageServiceImpl(StorageMapper storageMapper) {
        this.storageMapper = storageMapper;
    }

    @Override
    public void decrease(String commodityCode, Integer count) {
        Storage storage = storageMapper.selectOne(new LambdaQueryWrapper<Storage>()
                .eq(Storage::getCommodityCode, commodityCode));
        storage.setCount(storage.getCount() - count);
        storageMapper.updateById(storage);
    }
}
