package com.zjx.cloud.alibaba.service.impl;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.zjx.cloud.alibaba.entity.Order;
import com.zjx.cloud.alibaba.mapper.OrderMapper;
import com.zjx.cloud.alibaba.service.IOrderService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zjx.cloud.alibaba.service.IStorageService;
import io.seata.core.context.RootContext;
import io.seata.spring.annotation.GlobalTransactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author zjx
 * @since 2024-08-02
 */
@DS("db1")
@Service
@Slf4j
public class OrderServiceImpl extends ServiceImpl<OrderMapper, Order> implements IOrderService {

    private final IStorageService storageService;
    private final OrderMapper orderMapper;

    @Autowired
    public OrderServiceImpl(IStorageService storageService, OrderMapper orderMapper) {
        this.storageService = storageService;
        this.orderMapper = orderMapper;
    }

    @GlobalTransactional(name = "test",rollbackFor = Exception.class)
    @Override
    public void addOrder(String tag) {
        log.info("当前 XID: {}", RootContext.getXID());
        Order order = new Order();
        order.setCommodityCode("0001");
        order.setCount(1);
        // 加订单
        orderMapper.insert(order);
        if(tag.equals("00")) throw new RuntimeException("模拟业务异常！！！！");
        // 减库存
        storageService.decrease(order.getCommodityCode(),order.getCount());
    }
}
