package com.zjx.cloud.alibaba.generator;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.Types;
import java.util.Collections;
import java.util.Map;
/**
 * 适用于多数据源
 * 读取 DynamicDataSource 配置中的多个数据源，指定数据源名称即可为其生成代码
 */
@Slf4j
@Component
public class FastAutoGeneratorWithSpring {
    @Autowired
    private DataSource dataSource;
    public void generatorWithSpring(String dataSourceName) {
        // 获取当前所有数据源
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource) dataSource;
        Map<String, DataSource> dbMap = ds.getDataSources();
        log.info("数据源列表：----------{}", dbMap.keySet());
        FastAutoGenerator.create(new DataSourceConfig.Builder(dbMap.get(dataSourceName)))
                .globalConfig(builder -> {
                    builder.author("zjx") // 设置作者
                            // .enableSwagger() // 开启 swagger 模式
                            .outputDir("D://test"); // 指定输出目录
                })
                .dataSourceConfig(builder ->
                        builder.typeConvertHandler((globalConfig, typeRegistry, metaInfo) -> {
                            int typeCode = metaInfo.getJdbcType().TYPE_CODE;
                            if (typeCode == Types.SMALLINT) {
                                // 自定义类型转换
                                return DbColumnType.INTEGER;
                            }
                            return typeRegistry.getColumnType(metaInfo);
                        })
                )
                .packageConfig(builder ->
                        builder.parent("com.zjx.cloud.alibaba") // 设置父包名
                                .pathInfo(Collections.singletonMap(OutputFile.xml, "D://test")) // 设置mapperXml生成路径
                )
                .strategyConfig(builder ->
                        builder.addInclude("order_tb") // 设置需要生成的表名
                                .addTablePrefix("t_", "c_") // 过滤表前缀
                                .addTableSuffix("tb")       // 过滤表后缀
                                .entityBuilder()
                                .superClass("com.zjx.BaseEntity") // 实体类父类
                                .enableLombok()
                )
                .templateEngine(new FreemarkerTemplateEngine()) // 使用Freemarker引擎模板，默认的是Velocity引擎模板
                .execute();
    }

}
