package com.zjx.cloud.alibaba.generator;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Collections;
/**
 * 快速生成
 */
public class FastAutoGeneratorSimple {
    public static void main(String[] args) throws SQLException {
        FastAutoGenerator.create("jdbc:mysql://127.0.0.1:3306/seata_storage", "root", "root")
                .globalConfig(builder -> {
                    builder.author("zjx") // 设置作者
                            // .enableSwagger() // 开启 swagger 模式
                            .outputDir("D://test"); // 指定输出目录
                })
                .dataSourceConfig(builder ->
                        builder.typeConvertHandler((globalConfig, typeRegistry, metaInfo) -> {
                            int typeCode = metaInfo.getJdbcType().TYPE_CODE;
                            if (typeCode == Types.SMALLINT) {
                                // 自定义类型转换
                                return DbColumnType.INTEGER;
                            }
                            return typeRegistry.getColumnType(metaInfo);
                        })
                )
                .packageConfig(builder ->
                        builder.parent("com.zjx.cloud.alibaba") // 设置父包名
                                .pathInfo(Collections.singletonMap(OutputFile.xml, "D://test")) // 设置mapperXml生成路径
                )
                .strategyConfig(builder ->
                        builder.addInclude("storage_tb") // 设置需要生成的表名
                                .addTablePrefix("t_", "c_") // 过滤表前缀
                                .addTableSuffix("tb")       // 过滤表后缀
                                .entityBuilder()
                                .enableLombok()
                )
                .execute();
    }
}