package com.zjx.cloud.alibaba.controller;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

@RestController
public class TestController {

    @Value("${server.port}")
    private String port;

    @GetMapping(value = "/my-app/test/echo/{name}")
    @SentinelResource(blockHandler = "myHandler")
    public String echoTest(@PathVariable("name") String name,
                           @RequestParam("age") String age,
                           @RequestParam("sex") String sex) {
        // try {Thread.sleep(5000);} catch (Exception ignored) {}
        return "测试控制器！ " + name + ",port:" + port + ",age:" + age + ",sex:" + sex;
    }

    public String myHandler(String name, BlockException ex) {
        return "限流（服务熔断）提示：失败了！" + ex.getMessage() + "方法参数：" + name;
    }


    @GetMapping(value = "/my-app-1/test/echo1/hi")
    public String echoTest01() {
        return "测试sentinel网关流控，根据【路由id】限流！qps=1 ,port:" + port ;
    }

    @GetMapping(value = "/my-app-2/test/echo2/hi")
    public String echoTest02() {
        return "测试sentinel网关流控，根据【url前缀】限流！qps=3 ,port:" + port ;
    }

    @GetMapping(value = "/my-app-2/test/echo3/hi")
    public String echoTest03() {
        return "测试sentinel网关流控，【精确url】限流！ qps=3 ,port:" + port ;
    }

}
