package com.zjx.cloud.alibaba;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@EnableDiscoveryClient
public class NacosProviderDemoApplication {
    public static void main(String[] args) {
        SpringApplication.run(NacosProviderDemoApplication.class, args);
    }

    @RestController
    public static class EchoController {
        @Value("${server.port}")
        private String port;

        @GetMapping(value = "/echo/pro/{name}")
        @SentinelResource(value = "test01",
                blockHandler = "myHandler"     // 指定服务熔断方法
        )
        public String echo(@PathVariable("name") String name) {
            // try {Thread.sleep(5000);} catch (Exception ignored) {}
            return "Hello Nacos provider " + name + ",port:" + port;
        }

        public String myHandler(String name, BlockException ex) {
            return "限流（服务熔断）提示：失败了！" + ex.getMessage() + "方法参数：" + name;
        }
    }
}
