package com.zjx.cloud.alibaba.config;


import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

/**
 * 自定义 Gateway 谓词--配置会员才能访问
 * 注意类的命名规则为： 名称 + RoutePredicateFactory
 */
@Slf4j
@Component
public class MyRoutePredicateFactory extends AbstractRoutePredicateFactory<MyRoutePredicateFactory.Config> {
    public MyRoutePredicateFactory() {
        super(MyRoutePredicateFactory.Config.class);
    }
    // 具体放行逻辑
    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        // 若配置文件中指定 -My=BIG_VIP，则 http://xxx?tagParam=BIG_VIP才能通过
        return serverWebExchange -> {
            String tagParam = serverWebExchange.getRequest()
                    .getQueryParams().getFirst("tagParam");
            if (tagParam == null) {
                log.info("非常抱歉，你没有告诉我你是不是VIP，走开！！！");
                return false;
            }
            boolean isVip = tagParam.equals(config.getTag());
            if (!isVip) log.info("你不是VIP，走开！！！");
            return isVip;
        };
    }
    @Data
    public static class Config {
        private String tag;
    }
    /**
     * ========= 使配置支持简写 =========
     * yml简写形式：
     *    predicates:
     *      -My=BIG_VIP
     * 非简写形式：
     *    predicates:
     *      - name: My
     *          args:
     *            tag: BIG_VIP
     */
    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("tag");
    }
}
