package com.zjx.cloud.alibaba.config;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;

/**
 * 自定义 Gateway 过滤器--配置年龄 18+ 的男性 才能访问
 * 注意类的命名规则为： 名称 + GatewayFilterFactory
 */
@Slf4j
@Component
public class MyGatewayFilterFactory extends AbstractGatewayFilterFactory<MyGatewayFilterFactory.Config> {
    public MyGatewayFilterFactory() {
        super(MyGatewayFilterFactory.Config.class);
    }
    @Override
    public GatewayFilter apply(MyGatewayFilterFactory.Config config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            ServerHttpResponse response = exchange.getResponse();
            // 检查请求参数 【注意，request.getBody()只能被调用一次，不太适合在网关层操作请求体】
            Integer age = Integer.valueOf(request.getQueryParams().getFirst("age"));
            String sex = request.getQueryParams().getFirst("sex");
            // 放行
            if ( age >= config.getAge()
                    && config.getSex().equals(sex)) {
                return chain.filter(exchange);
            }
            // 不放行
            log.info("未满18岁或非男性，不适合访问！");
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            return response.setComplete();
        };
    }
    @Data
    public static class Config {
        private Integer age;
        private String sex;
    }

/**
 * ========= 使配置支持简写 =========
 * yml简写形式：
 *    filters:
 *      - My=18,男性
 * 非简写形式：
 *    filters:
 *      - name: My
 *          args:
 *            age: 18
 *            sex: 男性
 */
    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("age","sex");
    }
}
