package com.zjx.cloud.alibaba.consumer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@SpringBootApplication
@EnableDiscoveryClient
public class NacosConsumerDemoApplication {

    public static void main(String[] args) {
        SpringApplication.run(NacosConsumerDemoApplication.class, args);
    }

    @Bean
    @LoadBalanced      //使用负载均衡
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @RestController
    public static class EchoController {

        @Autowired
        private RestTemplate restTemplate;

        @GetMapping(value = "/echo/con/{name}")
        public String echo(@PathVariable("name") String name) {
            return restTemplate.getForObject(
                    String.format("http://cloud-alibaba-provider/echo/pro/%s", name), String.class);
        }
    }
}
