package com.zjx.cloud.alibaba.config;

import feign.Logger;
import feign.Retryer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyFeignConfig {
    // 配置重试机制，默认重试未开启，建议只在幂等性接口中开启重试机制
    @Bean
    public Retryer retryer() {
        // 初始间隔时间100ms,重试最大间隔时间1s,最多访问次数3次
        return new Retryer.Default(100,1,3);
    }

    // 开启日志打印功能，适合开发环境，注意需要在配置文件中,修改logging配置项指定feign接口路径
    @Bean
    Logger.Level feignLogLevel() {
        return Logger.Level.FULL;
    }

}
