package com.zjx.cloud.alibaba.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@EnableDiscoveryClient
public class CloudAlibabaConfigApplication {
    public static void main(String[] args) {
        SpringApplication.run(CloudAlibabaConfigApplication.class, args);
    }
    @RestController
    // 在控制器加上 @RefreshScope ，Nacos 服务器端更新可以立即读取
    @RefreshScope
    public static class TestController {
        @Value("${config.info}")
        private String info;
        @GetMapping(value = "/echo/config-info")
        public String echo() {
            return "Hello Nacos config info:" + info;
        }
    }
}
